/*----------------------------------------------------------------------------
                                INFORMATION    
  ----------------------------------------------------------------------------*/

/* Highly customizable Ventilation grill based on SVG shapes - Version 1.1
   This code enables to create Ventilation grids in a higly customizable way. 
   Written by Kakiemon @ Thingiverse
   Rolf Jethon
   Licensed under Creative common Attribution-NonCommercial-ShareAlike 4.0 #
   International (CC BY-NC-SA 4.0): https://creativecommons.org/licenses/by-nc-sa/4.0/

   HOW TO USE THIS FILE :  I recommend to use the OpenScad Customizer

   -- Solution 1 :
   Open this file with OpenScad software (free and open-source)
   http://www.openscad.org/downloads.html
   Choose your parameters in the SETTINGS chapter (see below)
   Press F5 to compile and see the resulting part
   Check your hook's global size in the console window (below viewing area)
   If OK, press F6 to render
   Go to : File => Export => Export as STL : choose filename and location
   Save the STL file of your customized grill
   Send this STL file to your 3D printer

   -- Solution 2 :
   This file had been optimized for the Customizer in OpenSCAD
   Just change the parameters in the customizer section
*/
/*------------------------------------------------------------------------------
With this program you can create ventilation grills of various 
sizes and shapes, Not too much attention  needs
to be taken to parametrize the parts. In most cases the resulting parts are
still sensful if the obvious size relations remain reasonable. 
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------
                                SETTINGS          
 ----------------------------------------------------------------------------*/

/* [General] */
// The overall height of the result
height=15;//[1:1:100]
// Thickness of SVG outline, set to 0 for a block item, 1 or more for an outline
tube_wall = 2;//[0.1:0.1:30]
// the width of the brim - means additional outline to cover the tube hole in the target plate safely
brim_size=10;//[0:0.1:30]
// the height of the brim, so the brim is stable enough
brim_height=1;//[0:0.1:10]
// round  the edges of the brim if selected
round_brim="no";//[yes,no]
// Grid to SVG size relation - increase if grid is too small 
grid_raw_size=160;//[10:5:800]
// accuracy segments
$fn=30;
/* [Import SVG] */
// Select a svg shape file to define the grid form 
file_to_import = "hand.svg";
// Scale the SVG in X direction
file_scale_x = 1; //[0.001:0.001:8]
// Scale the SVG in Y direction
file_scale_y = 1; //[0.001:0.001:8]
// flip SVG image
svg_flip = "no";//[yes,no]
/* [grill] */
// Size of the holes in x-direction
grid_x=6;//[0.1:0.1:500]
// Size of the holes in y-direction
grid_y=6;//[0.1:0.1:500]
// Grill height
grill_height=8;//[0.1:0.1:500]
// Thickness of the ribs in x-direction
grill_thickness_x=0.8;//[0.1:0.1:100]
// Thickness of the ribs in y-direction
grill_thickness_y=0.8;//[0.1:0.1:100]
// Slanting of the X-ribs
grill_angle_x=0;//[0:1:60]
// Slanting of the Y-ribs
grill_angle_y=0;//[0:1:60]
// Shifting of the ribs in X-direction out of the middle
grill_x_shift=0;//[-1:.01:1]
// Shifting of the ribs in Y-direction out of the middle
grill_y_shift=0;//[-1:.01:1]
// Rotation angle of the grill ribs around the center
grill_rotation=45;//[0:180]

// calculate some base sizes
grill_x=grid_x+grill_thickness_x/cos(grill_angle_x);
grill_y=grid_y+grill_thickness_y/cos(grill_angle_y);
slanted_grill_height=grill_height*10;
maxsize_x=grid_raw_size*file_scale_x; // this helps to calculate the required raw grid size,
                                      // so the whole inner vent is covered with grid
maxsize_y=grid_raw_size*file_scale_y; // unfortunately OpenScad does not provide SVG sizes, 
                                      // so testing the grid size is still necessary 
                                      // at least once the "Grid_raw_size" is set scaling does
                                      // not rquire to re- adjust the raw grid size

final(); // make the object

//----------------------------- Modules ------------------------------------------

/// make the segment
module final(){         
union(){    
  grillborder();
  intersection() {  
    translate([0,0,+0.01])
    linear_extrude(grill_height)
    grillmask();
    grill();  
  }
}
}


/// the mask that later cuts off all unnecessary grill parts
module grillmask() {
  if (svg_flip == "yes"){
    rotate([0,180])    
    base_svg();
  } else {
    base_svg();
  }      
}

/// the extruded grill tube
module grillborder(){                      // creates the extrudet tube 
union () {  
  linear_extrude(height)                 // make the tube border 3D
  svgtube(); 
  linear_extrude(brim_height)    
  svgbrim();
}
}

/// Brim base (2D) - flip the brim shape depending on the parameters 
module svgbrim(){
if(svg_flip == "yes"){
    rotate([0,180])
    svg_brim();
} else {
    svg_brim();
}    
}
  
/// make the brim shape out of the svg shape + offset - rounding according to parameters
module svg_brim(){  
  if (round_brim == "yes") {
  difference(){
    offset(brim_size+tube_wall){
      base_svg();
    }
    base_svg(); 
  }      
  } else {    
  difference(){
    offset(delta=brim_size+tube_wall){
      base_svg();
    }
    base_svg(); 
  }
 }
}  
/// Tube base (2D) - flip the tube shape depending on the parameters
module svgtube(){
if(svg_flip == "yes"){
    rotate([0,180])
    svg_tube();
} else {
    svg_tube();
}    
}
  
/// make the tube shape out of the svg shape + offset
module svg_tube(){    
  difference(){
     offset(delta=tube_wall){
        base_svg();
     } 
  base_svg(); 
  }
}

/// Import the svg file and scale according to the parameters  
module base_svg() {
 scale([file_scale_x,file_scale_y]){
  import(file_to_import, center = true);    
 }
} 

// Make the raw grill according to the parameters
module grill() {
 rotate([0,0,grill_rotation])   
 union(){
for (a =[0:grill_x:(maxsize_x/2)])
{
    translate([(grill_x_shift*grid_x)-a,0,0])
    rotate([0,grill_angle_x,0])
    cube([grill_thickness_x,maxsize_y,slanted_grill_height],center=true);
    translate([a+grill_x_shift*grid_x,0,0])
    rotate([0,grill_angle_x,0])
    cube([grill_thickness_x,maxsize_y,slanted_grill_height],center=true);
}

for (a =[0:grill_y:(maxsize_y/2)])
{
    translate([0,grill_y_shift*grid_y-a,0])
    rotate([grill_angle_y,0,0])
    cube([maxsize_x,grill_thickness_y,slanted_grill_height],center=true);
    translate([0,a+grill_y_shift*grid_y,0])
    rotate([grill_angle_y,0,0])
    cube([maxsize_x,grill_thickness_y,slanted_grill_height],center=true);
}
}   
}

