## Joystick firmware for Atmega32U4 propagating as USB HID analog joystick to be used for the bechele project
This firmware is for arduino pro micro with Atmega32U4 and is intended for the bechele project: 
https://github.com/bechele/bechele
For the animatronics software bechele it is very helpful to have a precise Joystick that has no dead zones. The Bechele software is running on Linux, usually on a raspberry Pi and the Joystick device /dev/js0 adds a large dead zone in the middle position of the stick. The dead zone is hard coded inside the kernel and cannot be changed easily. In other words, a conventional joystick is not good for the bechele software. It works, but you have to live with the dead zone. This firmware outwits the Kernel by propagating a Joystick with a conventional range of +/- 32767 steps, but never delivers the negative values. Since the bechele software has its own calibration values, still the full range of the joystick is possible, but this trick overcomes the deadzone. 

## Alternative projects using different hardware 
Alternative hardware exists, you may use for the same purpose. Note that the Arduino has a ADC with 10 bit resolution, reflecting a value range of 0 to 1024. Other maker boards, such as ESP32C3 or RPI2040 have ADCs with 12 bit resolution This means, the accuracy of these boards is higher. Therefore also have a look at the following projects:

## Installation onto a Atmega32U4 pico board:
### Option 1 - build und upload using Visual Studio Code.
Pre-conditions:
Visual Studio Code
Extension platformio for visual studio code

### Steps:
- Downlad the package from github as a .zip or clone directly from within Visual Studio code: https://bechele/arduino_micro_pro_joystick
- Once you have cloned the package within visual studio: In the VS code explorer (document icon on the upper left of the screen) locate the file platformio.ini Propably you need to change the com port to upload to in your file platformio.ini file. 
- You may then compile the downloaded package within platformio: On the left of your Visual code main window you should see a alien head. Ckick onto this head - then you see a list of actions in section platform on the upper left of the screen. Click onto "Build" to start compiling.
- Connect your Arduino via USB to your computer.  
- After successfully compiling you may upload the firmware to the Arduino pro micro board by clicking onto upload.
- once the upload has finished, the firmware is installed. With the next reboot it will start into joystick mode and will be visible as HID device on your computer.

### Option 2 - upload the hex file 
- in .pio\build\promicro\firmware.hex the compiled hex file exists. 
- You may upload it to your Arduino.
- Therefore you need a uploading utility. 
- There are different available for download 
- search for "upload hex file to arduino pro micro" using your favourite search engine

## Necessary steps to use the joystick in the bechele software:
To use the joystick with the bechele software, the following steps are necessary:
Connect the Joystick via USB to your microcomputer running the bechele software.
- login to the microcomputer and type:
ls -l /dev    You should see a device called js0
- If js0 is existing, your joystick has been recognised by the operating system
- type: /usr/local/bin/gamepad.pl
This will show you the joystick functions
- Operate the joystick and note the axes numbers and their limit values, when you fully move to the either mechanical block. Also note the button numbers:
Should be axis 0 (X-direction) and 1 (Y-direction) and Button 0 and 1
- Open the file /usr/local/bin/bechele/Modules/ConfigL.pm and set the follwing variables accordingly:
```
$use_gamepad=0;                                 # Set this to 1, because you use a HID Joystick, not a serial
$gamepad_start=0;                               # define which gamepad button starts
$gamepad_stop=1;                                # define gamepad button that stops
$gamepad_axis_y=1;                              # define the gamepad axis y
$gamepad_axis_x=0;                              # define the gamepad axis x
```
- Enter the limit values of your axes - With the Atmega32U4 joystick they should be similar to the values below:
```
$gamepad_x_start=0;                             # The axis x mechanical start limit value
$gamepad_x_end=32767;                           # The axis x mechanical end limit value
$gamepad_y_start=32767;                         # The axis y mechanical start limit value
$gamepad_y_end=0;                               # The axis y mechanical end limit value
```
- Depending on the direction the start and end values may be swapped. 
- Save and quit ConfigL.pm